function [xRD,yRD]=kmlpath(fname)
% [xRD,yRD]=kmlpath(fname)
% get the RD coordinates from an kml path files
% as obtained from google eary using the add path from the menu
%
% TO 091215

fp=fopen(fname,'r');
if fp<0, error('Can''t open file <<%s>>',fname); end

s=fgetl(fp);
while s~=-1
    if findstr('<coordinates>',s)
        s=fgetl(fp);                  % coordinates are on next line
        i=findstr('</co',s); 
        s(i:end)='';                  % remove trail
        s(s==',')=' ';                % remove commas
        crds=sscanf(s,'%f',[3,Inf])'; % scanf coords from string
        E=crds(:,1);                  % get Easting
        N=crds(:,2);                  % get Northing
        [xRD,yRD]=wgs2rd(E,N);        % translate to rd coordinates
        break;
    end
    s=fgetl(fp);
end

fclose(fp);
